<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-10-20
 *
 * @package     iCagenda.Admin
 * @subpackage  src.Controller
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8
 *----------------------------------------------------------------------------
*/

namespace WebiC\Component\iCagenda\Administrator\Controller;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Plugin\PluginHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * iCagenda Component Display Controller
 */
class DisplayController extends BaseController
{
	/**
	 * The default view
	 *
	 * @var    string
	 */
	protected $default_view = 'icagenda';

	protected $j5_php     = '8.3';
	protected $j5_php_min = '8.1.0';
	protected $j4_php     = '8.2';
	protected $j4_php_min = '7.2.5';

	/**
	 * Method to display a view
	 *
	 * @param   boolean  $cachable   If true, the view output will be cached.
	 * @param   array    $urlparams  An array of safe URL parameters and their variable types, for valid values see {@link \JFilterInput::clean()}.
	 *
	 * @return  static|boolean  This object to support chaining.
	 */
	public function display($cachable = false, $urlparams = [])
	{
		if (!PluginHelper::isEnabled('system', 'icagenda')) {
			$alert_message = Text::sprintf('COM_ICAGENDA_ERROR_PLUGIN_DISABLED', Text::_('COM_ICAGENDA_PLUGIN_SYSTEM_ICAGENDA'));

			$this->app->enqueueMessage($alert_message, 'error');

			echo Text::_('COM_ICAGENDA_ERROR_LOAD');

			return;
		}

		$view   = $this->input->get('view', 'icagenda');
		$layout = $this->input->get('layout', 'icagenda');
		$id     = $this->input->getInt('id');

		// Obsolete PHP version?
		if ($layout !== 'edit'
			&& version_compare(phpversion(), (version_compare(JVERSION, '5', '<') ? $this->j4_php_min : $this->j5_php_min), '<')
		) {
			$JoomlaMinimum     = (version_compare(JVERSION, '5', '<') ? $this->j4_php_min : $this->j5_php_min) . ' +';
			$JoomlaRecommended = (version_compare(JVERSION, '5', '<') ? $this->j4_php : $this->j5_php) . ' +';

			$icon_warning    = '<span class="cpanel-icon-warning"></span>';
			$php_warning_msg = '<p><strong> ' . Text::sprintf('COM_ICAGENDA_YOUR_PHP_VERSION_IS', phpversion()) . '</strong></p>'
				. '<p>' . Text::sprintf('COM_ICAGENDA_PHP_VERSION_JOOMLA_RECOMMENDED', $JoomlaRecommended)
				. ' <small>(' . Text::sprintf('COM_ICAGENDA_PHP_VERSION_JOOMLA_MINIMUM', $JoomlaMinimum) . ')</small>'
				. '<br><a href="https://manual.joomla.org/docs/next/get-started/technical-requirements/"'
				. ' target="_blank">https://manual.joomla.org/docs/next/get-started/technical-requirements/</a>'
				. '</p>'
				. '<p>' . Text::_('COM_ICAGENDA_PHP_VERSION_ICAGENDA_RECOMMENDATION') . '</p>';

			$this->app->enqueueMessage($icon_warning . $php_warning_msg, 'error');
		}

		// Access check.
		if ( ! $this->app->getIdentity()->authorise('core.manage', 'com_icagenda')) {
			$this->setMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');

			return false;
		}

		// Check for edit form.
		if ($view == 'event' && $layout == 'edit' && !$this->checkEditId('com_icagenda.edit.event', $id)) {
			// Somehow the person just went to the form - we don't allow that.
			if (!\count($this->app->getMessageQueue())) {
				$this->setMessage(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 'error');
			}

			$this->setRedirect(Route::_('index.php?option=com_icagenda&view=events', false));

			return false;
		} elseif ($view == 'iCategory' && $layout == 'edit' && !$this->checkEditId('com_icagenda.edit.category', $id)) {
			// Somehow the person just went to the form - we don't allow that.
			if (!\count($this->app->getMessageQueue())) {
				$this->setMessage(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 'error');
			}

			$this->setRedirect(Route::_('index.php?option=com_icagenda&view=categories', false));

			return false;
		} elseif ($view == 'registration' && $layout == 'edit' && !$this->checkEditId('com_icagenda.edit.registration', $id)) {
			// Somehow the person just went to the form - we don't allow that.
			if (!\count($this->app->getMessageQueue())) {
				$this->setMessage(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 'error');
			}

			$this->setRedirect(Route::_('index.php?option=com_icagenda&view=registrations', false));

			return false;
		} elseif ($view == 'customfield' && $layout == 'edit' && !$this->checkEditId('com_icagenda.edit.customfield', $id)) {
			// Somehow the person just went to the form - we don't allow that.
			if (!\count($this->app->getMessageQueue())) {
				$this->setMessage(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 'error');
			}

			$this->setRedirect(Route::_('index.php?option=com_icagenda&view=customfields', false));

			return false;
		} elseif ($view == 'feature' && $layout == 'edit' && !$this->checkEditId('com_icagenda.edit.feature', $id)) {
			// Somehow the person just went to the form - we don't allow that.
			if (!\count($this->app->getMessageQueue())) {
				$this->setMessage(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 'error');
			}

			$this->setRedirect(Route::_('index.php?option=com_icagenda&view=features', false));

			return false;
		}

		// Load translations
		$language = $this->app->getLanguage();
		$language->load('com_icagenda', JPATH_ADMINISTRATOR, 'en-GB', true);
		$language->load('com_icagenda', JPATH_ADMINISTRATOR, null, true);

		// Load Vector iCicons Font
		HTMLHelper::_('stylesheet', 'media/com_icagenda/icicons/style.css');

		// Shared CSS
		HTMLHelper::_('stylesheet', 'com_icagenda/icagenda.css', ['relative' => true, 'version' => 'auto']);

		// CSS files which could be overridden into the site template. (eg. /templates/my_template/css/com_icagenda/icagenda-back.css)
		HTMLHelper::_('stylesheet', 'com_icagenda/icagenda-back.css', ['relative' => true, 'version' => 'auto']);

		// Check iCagenda System Errors
		$systemReady = $this->app->triggerEvent('onICagendaSystemCheck');

		if (\is_array($systemReady) && \count($systemReady) > 0
			&& \in_array(false, $systemReady, true)
			&& $view != 'icagenda'
		) {
			echo Text::_('COM_ICAGENDA_ERROR_LOAD');

			return;
		}

		@include_once(__DIR__ . '/../../version.php');

		if (!defined('ICAGENDA_VERSION')) {
			define('ICAGENDA_VERSION', 'dev');
			define('ICAGENDA_RELDATE', date('Y-m-d'));
		}

		return parent::display();
	}
}
