<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-11-23
 *
 * @package     iCagenda.Site
 * @subpackage  Layout
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.8.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string   basePath         Base path to use when loading layout files (theme pack)
 * @var   integer  canCancel        1 if cancellation is enabled, 0 if disabled.
 * @var   string   cancelUrl        Cancel Registration Url.
 * @var   string   customLink       Custom registration link.
 * @var   boolean  eventDetails     True if event details view.
 * @var   array    extraDates       List of availables dates.
 * @var   mixed    registered       Number of registered users.
 * @var   string   registerTarget   Register button browser target.
 * @var   string   registerUrl      Registration Url.
 * @var   string   status           Status of registration button.
 * @var   string   textButton       Custom register text for button.
 * @var   array    userBooked       Logged-in user has registration(s) for this event.
 */
?>

<div class="ic-registration-box">

	<div class="ic-button-box ic-registration-box-register-<?php echo $status; ?>">
		<?php echo $this->sublayout('register', $displayData); ?>
	</div>

	<?php if ($eventDetails && $canCancel && \count($userBooked) > 0) : ?>
	<div class="ic-button-box ic-registration-box-cancel">
		<?php echo $this->sublayout('cancel', $displayData); ?>
	</div>
	<?php endif; ?>

	<?php if ($eventDetails) : ?>
	<div class="ic-button-box ic-registration-box-info">
		<?php echo $this->sublayout('info', $displayData); ?>
	</div>
	<?php endif; ?>

</div>
