<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *              Module iCagenda Calendar
 *----------------------------------------------------------------------------
 * @version     4.0.0 2025-08-30
 *
 * @package     iCagenda.Site
 * @subpackage  mod_icagenda_calendar
 * @link        https://www.joomlic.com
 *
 * @author      Cyril Reze
 * @copyright   (c) 2012-2026 Cyril Reze / JoomliC. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       4.0.0
 *----------------------------------------------------------------------------
 */

namespace WebiC\Module\IcagendaCalendar\Site\Dispatcher;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Input\Input;
use Joomla\Registry\Registry;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Dispatcher class for mod_icagenda_calendar
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
	use HelperFactoryAwareTrait;

	protected $module;
	
	protected $app;

	public function __construct(\stdClass $module, CMSApplicationInterface $app, Input $input)
	{
		$this->module = $module;
		$this->app = $app;
	}

	/**
	 * Runs the dispatcher.
	 *
	 * @return  void
	 */
	public function dispatch()
	{
		$displayData = $this->getLayoutData();

		$params = new Registry($this->module->params);

		require ModuleHelper::getLayoutPath('mod_icagenda_calendar');
//		parent::dispatch();
	}

	/**
	 * Returns the layout data.
	 *
	 * @return  array
	 */
//	protected function getLayoutData()
//	{
		// Get the module Parameters
//		$params = new Registry($this->module->params);
//		$data   = parent::getLayoutData();
//
//		$helperName    = 'IcagendaCalendarHelper';
////		$data['mymsg'] = $this->getHelperFactory()->getHelper($helperName)->getMessage($data['params'], $this->getApplication());
//		return $data;
//	}
}
